﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class GenerationConfiguration : ConfigurationElement
{
    
    public DecorationConfiguration Decoration { get; private set; }

    public int BuildingTypeNoiseZoneSize { get; private set; }
    public float BuildingTypeNoiseZonePerlinCap { get; private set; }
    public float SkyscraperPerlinMultiplier { get; private set; }
    public float CommercialPerlinMultiplier { get; private set; }
    public int PerlinOffsetClamp { get; private set; }

    public GenerationConfiguration() : base("Generation")
    {
        
    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            BuildingTypeNoiseZoneSize = Convert.ToInt32(configElem.Element("BuildingTypeNoiseZoneSize").Value);
            BuildingTypeNoiseZonePerlinCap = Convert.ToSingle(configElem.Element("BuildingTypeNoiseZonePerlinCap").Value);
            SkyscraperPerlinMultiplier = Convert.ToSingle(configElem.Element("SkyscraperPerlinMultiplier").Value);
            CommercialPerlinMultiplier = Convert.ToSingle(configElem.Element("CommercialPerlinMultiplier").Value);
            PerlinOffsetClamp = Convert.ToInt32(configElem.Element("PerlinOffsetClamp").Value);

            //Create our sub-configuration objects
            Decoration = new DecorationConfiguration();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (Decoration.Parse(configElem.Element("Decoration")))
            {
                return true;    //Parsed everything successfully!
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse generation configuration. Perhaps the XML is malformed?");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing generation configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
